/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.ria.servlet;

import com.ejie.ria.comun.RiaClsConstantes;
import com.ejie.ria.comun.RiaClsTrazas;
import com.ejie.ria.servlet.RiaJSMin;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RiaI18NServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private HashMap gridLiterals;
    private HashMap dialogLiterals;
    private ArrayList propertiesNames = new ArrayList();
    private Properties propertiesTabla = new Properties();
    private static final String FILE_PROPERTIES = RiaI18NServlet.obtenerUbicacionGridLiterals();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String idioma;
        String encoding = new String();
        RiaJSMin jsmin = null;
        StringBuffer sb = new StringBuffer();
        String datosI18N = new String();
        Q70ContextoEJIE contexto = (Q70ContextoEJIE)request.getSession().getAttribute("contexto");
        try {
            idioma = (String)contexto.get(RiaClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
            if (idioma == null || idioma.equals("")) {
                throw new ServletException("Problemas con la obtencion del idioma del contexto de Geremua (se obtiene un nulo o dato vacio)\n");
            }
        }
        catch (Exception e) {
            throw new ServletException("Problemas con la obtencion del idioma del contexto de Geremua (se produce una excepcion).\nLa variable de contexto de aplicaci\u00f3n \"" + RiaClsConstantes.CONSTANTE_CONTEXTO_IDIOMA + "\", que controla el idioma en el que se presenta la aplicaci\u00f3n, no esta definido.\n La excepticion devuelta es: " + e.getMessage() + "\n");
        }
        String component = request.getParameter("component");
        if (component != null && component.equals("tabla")) {
            this.cargarLiteralesGridSesion(request);
            if (this.gridLiterals.containsKey(idioma)) {
                datosI18N = (String)this.gridLiterals.get(idioma);
            } else {
                RiaClsTrazas.debug("RiaGridI18NServlet.processOP() - Se componen los literales (i18n) del idioma=" + idioma + " para la tabla");
                this.propertiesNamesProcessing(FILE_PROPERTIES, idioma);
                sb.append(this.obtenerLiteralesTabla());
                sb.append(this.obtenerLiteralesValidacion());
                sb.append(this.obtenerLiteralesgenerales());
                datosI18N = sb.toString();
                this.gridLiterals.put(idioma, datosI18N);
                this.GuardarliteralesSesion(request);
            }
            response.setContentType("text/javascript;charset=iso-8859-1");
            response.setHeader("Pragma", "cache");
            response.setHeader("Cache-Control", "public");
            response.setDateHeader("Expires", System.currentTimeMillis() + 1L);
            response.setStatus(200);
            encoding = request.getHeader("Accept-Encoding");
            if (encoding != null && encoding.indexOf("gzip") >= 0) {
                response.setHeader("Content-Encoding", "gzip");
            }
            datosI18N = this.headComplet(datosI18N, request.getParameter("editable") != null);
            RiaClsTrazas.debug("RiaGridI18NServlet.processOP() - JSON gzipeado y minimizado para i18n de la tabla");
        } else if (component != null && component.equals("dialogos")) {
            this.cargarLiteralesDialogosSesion(request);
            String dialogo = request.getParameter("dialog");
            String fichero = request.getParameter("fich");
            if (this.dialogLiterals.containsKey(String.valueOf(dialogo) + "_" + fichero + "_" + idioma)) {
                datosI18N = (String)this.dialogLiterals.get(String.valueOf(dialogo) + "_" + fichero + "_" + idioma);
            } else {
                RiaClsTrazas.debug("RiaGridI18NServlet.processOP() - Se componen los literales (i18n) del idioma=" + idioma + " para el dialogo " + dialogo + " del fichero " + fichero);
                sb.append(this.dialogPropertiesNamesProcessing(dialogo, fichero, idioma));
                datosI18N = sb.toString();
                this.dialogLiterals.put(String.valueOf(dialogo) + "_" + fichero + "_" + idioma, datosI18N);
                request.getSession().setAttribute("dialogLiterals", (Object)this.dialogLiterals);
            }
            response.setContentType("text/javascript;charset=iso-8859-1");
            response.setHeader("Pragma", "cache");
            response.setHeader("Cache-Control", "public");
            response.setDateHeader("Expires", System.currentTimeMillis() + 1L);
            response.setStatus(200);
            encoding = request.getHeader("Accept-Encoding");
            if (encoding != null && encoding.indexOf("gzip") >= 0) {
                response.setHeader("Content-Encoding", "gzip");
            }
            RiaClsTrazas.debug("RiaGridI18NServlet.processOP() - JSON gzipeado y minimizado para i18n del dialogo " + dialogo);
        }
        if (this.isGzipEncodingAvaible(encoding)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            jsmin = new RiaJSMin(new ByteArrayInputStream(datosI18N.getBytes()), baos);
            this.doJsmin(jsmin);
            ServletOutputStream o = response.getOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream((OutputStream)o);
            gz.write(baos.toString().getBytes());
            gz.close();
            o.close();
        } else {
            jsmin = new RiaJSMin(new ByteArrayInputStream(datosI18N.getBytes()), (OutputStream)response.getOutputStream());
            this.doJsmin(jsmin);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.doGet(req, resp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isGzipEncodingAvaible(String encoding) {
        return encoding != null && encoding.indexOf("gzip") >= 0;
    }

    private void doJsmin(RiaJSMin jsmin) {
        try {
            jsmin.jsmin();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RiaJSMin.UnterminatedRegExpLiteralException e) {
            e.printStackTrace();
        }
        catch (RiaJSMin.UnterminatedCommentException e) {
            e.printStackTrace();
        }
        catch (RiaJSMin.UnterminatedStringLiteralException e) {
            e.printStackTrace();
        }
    }

    private static String obtenerUbicacionGridLiterals() {
        String ruta = "/html/ria-ejie/ejie.gridi18nria";
        if (Q70ListenerUtils.getApplicationProperty((String)"RIA_RUTA_LITERALES_TABLA") != null) {
            ruta = Q70ListenerUtils.getApplicationProperty((String)"RIA_RUTA_LITERALES_TABLA");
        }
        return ruta;
    }

    private void propertiesNamesProcessing(String propertyFileUrl, String idioma) throws ServletException {
        try {
            this.propertiesTabla.load(((Object)((Object)this)).getClass().getResourceAsStream(String.valueOf(propertyFileUrl) + "_" + idioma + ".properties"));
        }
        catch (Exception e) {
            throw new ServletException("Error al acceder al fichero de properties: " + propertyFileUrl + "_" + idioma + ".properties" + "\n La excepticion devuelta es: " + e.getMessage() + "\n");
        }
        this.propertiesNames = this.ordenarAlfabeticamenteArray(Collections.list(this.propertiesTabla.propertyNames()));
    }

    private String dialogPropertiesNamesProcessing(String dialogName, String propertiesFileName, String idioma) throws ServletException {
        Properties propertiesDialogio = new Properties();
        String url = "/html/datos/" + propertiesFileName + "_" + idioma + ".properties";
        ArrayList names = new ArrayList();
        HashMap<String, String> arrayNames = new HashMap<String, String>();
        HashMap<String, ArrayList> hashMapNames = new HashMap<String, ArrayList>();
        StringBuffer cadenaLiterales = new StringBuffer();
        try {
            int i;
            String arrayName;
            Map.Entry entrada;
            int arrayLiteral;
            ArrayList auxObject;
            propertiesDialogio.load(((Object)((Object)this)).getClass().getResourceAsStream(url));
            ArrayList<?> allNames = Collections.list(propertiesDialogio.propertyNames());
            cadenaLiterales.append("{");
            int i2 = 0;
            while (i2 < allNames.size()) {
                String[] diviseName = this.divisorPunto((String)allNames.get(i2));
                int cadenaTam = this.divisorPunto(dialogName).length;
                if (((String)allNames.get(i2)).split(dialogName).length > 1) {
                    if (diviseName.length - cadenaTam >= 2) {
                        if (!this.isNumberFloat(diviseName[diviseName.length - 1].substring(diviseName[diviseName.length - 1].length() - 1))) {
                            if (hashMapNames.containsKey(diviseName[cadenaTam])) {
                                auxObject = (ArrayList)hashMapNames.get(diviseName[cadenaTam]);
                                auxObject.add((String)allNames.get(i2));
                                hashMapNames.put(diviseName[cadenaTam], auxObject);
                            } else {
                                auxObject = new ArrayList();
                                auxObject.add((String)allNames.get(i2));
                                hashMapNames.put(diviseName[cadenaTam], auxObject);
                            }
                        } else if (arrayNames.containsKey(((String)allNames.get(i2)).substring(0, ((String)allNames.get(i2)).length() - 1))) {
                            arrayLiteral = new Integer((String)arrayNames.get(((String)allNames.get(i2)).substring(0, ((String)allNames.get(i2)).length() - 1)));
                            arrayNames.put(((String)allNames.get(i2)).substring(0, ((String)allNames.get(i2)).length() - 1), new Integer(arrayLiteral + 1).toString());
                        } else {
                            arrayNames.put(((String)allNames.get(i2)).substring(0, ((String)allNames.get(i2)).length() - 1), "1");
                        }
                    } else {
                        names.add(allNames.get(i2));
                    }
                }
                ++i2;
            }
            allNames = null;
            if (hashMapNames.size() > 0) {
                Iterator iterator = hashMapNames.entrySet().iterator();
                while (iterator.hasNext()) {
                    entrada = iterator.next();
                    arrayName = (String)entrada.getKey();
                    auxObject = (ArrayList)entrada.getValue();
                    if (cadenaLiterales.length() > 1) {
                        cadenaLiterales.append(",\"" + arrayName + "\":{");
                    } else {
                        cadenaLiterales.append("\"" + arrayName + "\":{");
                    }
                    cadenaLiterales.append("\"" + this.cleaner((String)auxObject.get(0)) + "\":");
                    cadenaLiterales.append("\"" + propertiesDialogio.getProperty((String)auxObject.get(0)) + "\"");
                    i = 1;
                    while (i < auxObject.size()) {
                        cadenaLiterales.append(",\"" + this.cleaner((String)auxObject.get(i)) + "\":");
                        cadenaLiterales.append("\"" + propertiesDialogio.getProperty((String)auxObject.get(i)) + "\"");
                        ++i;
                    }
                    cadenaLiterales.append("}");
                }
            }
            if (arrayNames.size() > 0) {
                Iterator iterator = arrayNames.entrySet().iterator();
                while (iterator.hasNext()) {
                    entrada = iterator.next();
                    arrayName = (String)entrada.getKey();
                    arrayLiteral = new Integer((String)entrada.getValue());
                    if (cadenaLiterales.length() > 1) {
                        cadenaLiterales.append(",\"" + this.arrayCleaner(String.valueOf(arrayName) + "0") + "\":");
                        cadenaLiterales.append("[\"" + propertiesDialogio.getProperty(String.valueOf(arrayName) + "0") + "\"");
                    } else {
                        cadenaLiterales.append("\"" + this.arrayCleaner(String.valueOf(arrayName) + "0") + "\":");
                        cadenaLiterales.append("[\"" + propertiesDialogio.getProperty(String.valueOf(arrayName) + "0") + "\"");
                    }
                    i = 1;
                    while (i < arrayLiteral - 1) {
                        cadenaLiterales.append(",\"" + propertiesDialogio.getProperty(String.valueOf(arrayName) + i) + "\"");
                        ++i;
                    }
                    if (arrayLiteral == 1) {
                        cadenaLiterales.append("]");
                        continue;
                    }
                    cadenaLiterales.append(",\"" + propertiesDialogio.getProperty(String.valueOf(arrayName) + new Integer(arrayLiteral - 1).toString()) + "\"]");
                }
            }
            if (names.size() > 0) {
                if (cadenaLiterales.length() > 1) {
                    i = 0;
                    while (i < names.size()) {
                        cadenaLiterales.append(",\"" + this.cleaner((String)names.get(i)) + "\":");
                        cadenaLiterales.append("\"" + propertiesDialogio.getProperty((String)names.get(i)) + "\"");
                        ++i;
                    }
                } else {
                    cadenaLiterales.append("\"" + this.cleaner((String)names.get(0)) + "\":");
                    cadenaLiterales.append("\"" + propertiesDialogio.getProperty((String)names.get(0)) + "\"]");
                    i = 1;
                    while (i < names.size()) {
                        cadenaLiterales.append(",\"" + this.cleaner((String)names.get(i)) + "\":");
                        cadenaLiterales.append("\"" + propertiesDialogio.getProperty((String)names.get(i)) + "\"");
                        ++i;
                    }
                }
            }
            cadenaLiterales.append("}");
        }
        catch (Exception e) {
            throw new ServletException("Error al acceder al fichero de properties: " + url + "_" + idioma + ".properties" + "\n La excepticion devuelta es: " + e.getMessage() + "\n");
        }
        return cadenaLiterales.toString();
    }

    private String headComplet(String cadenaParcial, boolean editable) {
        StringBuffer frontal = new StringBuffer();
        frontal.append(";(function($){");
        if (editable) {
            frontal.append("$.fn.jq_ejie_tabla_editable.i18n=");
        } else {
            frontal.append("$.fn.jq_ejie_tabla.i18n=");
        }
        return String.valueOf(frontal.toString()) + cadenaParcial;
    }

    private String obtenerLiteralesTabla() {
        StringBuffer cadenaLiterales = new StringBuffer();
        ArrayList usedNames = new ArrayList();
        usedNames = this.nameExtractor("tabla");
        cadenaLiterales.append("{");
        cadenaLiterales.append(this.cadenaComposer(usedNames));
        cadenaLiterales.append("};");
        return cadenaLiterales.toString();
    }

    private String obtenerLiteralesValidacion() {
        StringBuffer cadenaLiterales = new StringBuffer();
        ArrayList usedNames = new ArrayList();
        usedNames = this.nameExtractor("validador");
        cadenaLiterales.append("$.fn.jq_ejie_validador=");
        cadenaLiterales.append("{");
        cadenaLiterales.append(this.cadenaComposer(usedNames));
        cadenaLiterales.append("}");
        cadenaLiterales.append(";");
        return cadenaLiterales.toString();
    }

    private String obtenerLiteralesgenerales() {
        StringBuffer cadenaLiterales = new StringBuffer();
        ArrayList usedNames = new ArrayList();
        usedNames = this.nameExtractor("grid-df");
        cadenaLiterales.append("$.jgrid.defaults=");
        cadenaLiterales.append("{");
        cadenaLiterales.append(this.cadenaComposer(usedNames));
        cadenaLiterales.append("}");
        cadenaLiterales.append(";");
        usedNames = this.nameExtractor("grid-sr");
        cadenaLiterales.append("$.jgrid.search=");
        cadenaLiterales.append("{");
        cadenaLiterales.append(this.cadenaComposer(usedNames));
        cadenaLiterales.append("}");
        cadenaLiterales.append(";");
        usedNames = this.nameExtractor("grid-ed");
        cadenaLiterales.append("$.jgrid.edit=");
        cadenaLiterales.append("{");
        cadenaLiterales.append(this.cadenaComposer(usedNames));
        cadenaLiterales.append("}");
        cadenaLiterales.append(";");
        usedNames = this.nameExtractor("grid-dl");
        cadenaLiterales.append("$.jgrid.del=");
        cadenaLiterales.append("{");
        cadenaLiterales.append(this.cadenaComposer(usedNames));
        cadenaLiterales.append("}");
        cadenaLiterales.append(";");
        usedNames = this.nameExtractor("grid-nv");
        cadenaLiterales.append("$.jgrid.nav=");
        cadenaLiterales.append("{");
        cadenaLiterales.append(this.cadenaComposer(usedNames));
        cadenaLiterales.append("}");
        cadenaLiterales.append(";");
        usedNames = this.nameExtractor("grid-cl");
        cadenaLiterales.append("$.jgrid.col=");
        cadenaLiterales.append("{");
        cadenaLiterales.append(this.cadenaComposer(usedNames));
        cadenaLiterales.append("}");
        cadenaLiterales.append(";");
        usedNames = this.nameExtractor("grid-er");
        cadenaLiterales.append("$.jgrid.errors=");
        cadenaLiterales.append("{");
        cadenaLiterales.append(this.cadenaComposer(usedNames));
        cadenaLiterales.append("}");
        cadenaLiterales.append(";");
        usedNames = this.nameExtractor("grid-fr");
        cadenaLiterales.append("$.jgrid.formatter=");
        cadenaLiterales.append("{");
        cadenaLiterales.append(this.cadenaComposer(usedNames));
        cadenaLiterales.append("};");
        cadenaLiterales.append("})(jQuery);");
        return cadenaLiterales.toString();
    }

    private ArrayList nameExtractor(String familia) {
        ArrayList<Object> finalProperties = new ArrayList<Object>();
        ArrayList finalPropertie = new ArrayList();
        ArrayList finalPropertieAnidado = new ArrayList();
        ArrayList<String> finalPropertieNuevo = new ArrayList<String>();
        ArrayList<String> finalPropertieAnidadoNuevo = new ArrayList<String>();
        String finalPropertieString = new String();
        String fragmentoPrecedente = new String();
        boolean doble = false;
        int i = 0;
        while (i < this.propertiesNames.size()) {
            String[] fragmentos = this.divisorPunto((String)this.propertiesNames.get(i));
            if (fragmentos[0].equals(familia)) {
                if (fragmentos.length > 2) {
                    if (finalProperties.size() > 0) {
                        String[] fragmentosPasados;
                        if (fragmentos.length > 3) {
                            fragmentosPasados = this.divisorPunto(fragmentoPrecedente);
                            finalPropertie = (ArrayList)finalProperties.get(finalProperties.size() - 1);
                            if (fragmentosPasados.length > 3) {
                                finalPropertieAnidado = (ArrayList)finalPropertie.get(finalPropertie.size() - 1);
                                finalPropertieAnidado.add((String)this.propertiesNames.get(i));
                            } else {
                                finalPropertieNuevo = new ArrayList();
                                finalPropertieNuevo.add(0, "compuesto");
                                finalPropertieNuevo.add(1, fragmentos[2]);
                                finalPropertieNuevo.add(2, (String)this.propertiesNames.get(i));
                                finalPropertie.add(finalPropertieNuevo);
                            }
                        } else {
                            fragmentosPasados = this.divisorPunto(fragmentoPrecedente);
                            if (fragmentosPasados.length > 2 && (fragmentosPasados[2].length() == fragmentos[2].length() || fragmentosPasados[2].length() + 1 == fragmentos[2].length())) {
                                if ((fragmentos[2].substring(0, fragmentos[2].length() - 1).equals(fragmentosPasados[2].substring(0, fragmentosPasados[2].length() - 1)) || fragmentos[2].substring(0, fragmentos[2].length() - 2).equals(fragmentosPasados[2].substring(0, fragmentosPasados[2].length() - 1)) || fragmentos[2].substring(0, fragmentos[2].length() - 2).equals(fragmentosPasados[2].substring(0, fragmentosPasados[2].length() - 2))) && !fragmentos[2].substring(0, fragmentos[2].length() - 1).equals("seleccion")) {
                                    if (fragmentosPasados[1].equals(fragmentos[1])) {
                                        finalPropertie = (ArrayList)finalProperties.get(finalProperties.size() - 1);
                                        if (finalPropertie.get(finalPropertie.size() - 1).getClass().getName().equals("java.util.ArrayList")) {
                                            finalPropertieAnidado = (ArrayList)finalPropertie.get(finalPropertie.size() - 1);
                                            finalPropertieAnidado.add((String)this.propertiesNames.get(i));
                                        } else {
                                            finalPropertieAnidadoNuevo = new ArrayList();
                                            finalPropertieAnidadoNuevo.add(0, "enumerado");
                                            finalPropertieAnidadoNuevo.add(1, (String)finalPropertie.get(finalPropertie.size() - 1));
                                            finalPropertieAnidadoNuevo.add(2, (String)this.propertiesNames.get(i));
                                            finalPropertie.remove(finalPropertie.size() - 1);
                                            finalPropertie.add(finalPropertieAnidadoNuevo);
                                        }
                                    } else {
                                        finalProperties.add((String)this.propertiesNames.get(i));
                                    }
                                } else if (fragmentosPasados[1].equals(fragmentos[1])) {
                                    finalPropertie = (ArrayList)finalProperties.get(finalProperties.size() - 1);
                                    finalPropertie.add((String)this.propertiesNames.get(i));
                                } else {
                                    finalPropertieNuevo = new ArrayList();
                                    finalPropertieNuevo.add(0, "compuesto");
                                    finalPropertieNuevo.add(1, fragmentos[1]);
                                    finalPropertieNuevo.add(2, (String)this.propertiesNames.get(i));
                                    finalProperties.add(finalPropertieNuevo);
                                }
                            } else if (fragmentosPasados[1].equals(fragmentos[1])) {
                                finalPropertie = (ArrayList)finalProperties.get(finalProperties.size() - 1);
                                finalPropertie.add((String)this.propertiesNames.get(i));
                            } else {
                                finalPropertieNuevo = new ArrayList();
                                finalPropertieNuevo.add(0, "compuesto");
                                finalPropertieNuevo.add(1, fragmentos[1]);
                                finalPropertieNuevo.add(2, (String)this.propertiesNames.get(i));
                                finalProperties.add(finalPropertieNuevo);
                            }
                        }
                    } else {
                        finalPropertieNuevo = new ArrayList();
                        finalPropertieNuevo.add(0, "compuesto");
                        finalPropertieNuevo.add(1, fragmentos[1]);
                        finalPropertieNuevo.add(2, (String)this.propertiesNames.get(i));
                        finalProperties.add(finalPropertieNuevo);
                    }
                } else if (finalProperties.size() > 0) {
                    if (doble) {
                        if (fragmentoPrecedente.substring(0, fragmentoPrecedente.length() - 2).equals(((String)this.propertiesNames.get(i)).substring(0, ((String)this.propertiesNames.get(i)).length() - 3))) {
                            if (finalProperties.get(finalProperties.size() - 1).getClass().getName().equals("java.util.ArrayList")) {
                                finalPropertie = (ArrayList)finalProperties.get(finalProperties.size() - 1);
                                finalPropertie.add((String)this.propertiesNames.get(i));
                                finalProperties.add(finalPropertie);
                            } else {
                                finalPropertieNuevo = new ArrayList();
                                finalPropertieString = (String)finalProperties.get(finalProperties.size() - 1);
                                finalPropertieNuevo.add(0, "enumerado");
                                finalPropertieNuevo.add(1, finalPropertieString);
                                finalPropertieNuevo.add(2, (String)this.propertiesNames.get(i));
                                finalProperties.add(finalProperties.size() - 1, finalPropertieNuevo);
                            }
                        } else {
                            finalProperties.add((String)this.propertiesNames.get(i));
                            doble = false;
                        }
                    } else if (fragmentoPrecedente.substring(0, fragmentoPrecedente.length() - 2).equals(((String)this.propertiesNames.get(i)).substring(0, ((String)this.propertiesNames.get(i)).length() - 2))) {
                        if (finalProperties.get(finalProperties.size() - 1).getClass().getName().equals("java.util.ArrayList")) {
                            finalPropertie = (ArrayList)finalProperties.get(finalProperties.size() - 1);
                            finalPropertie.add((String)this.propertiesNames.get(i));
                        } else {
                            finalPropertieNuevo = new ArrayList();
                            finalPropertieString = (String)finalProperties.get(finalProperties.size() - 1);
                            finalPropertieNuevo.add(0, "enumerado");
                            finalPropertieNuevo.add(1, finalPropertieString);
                            finalPropertieNuevo.add(2, (String)this.propertiesNames.get(i));
                            finalProperties.remove(finalProperties.size() - 1);
                            finalProperties.add(finalPropertieNuevo);
                        }
                        if (((String)this.propertiesNames.get(i)).substring(((String)this.propertiesNames.get(i)).length() - 1).equals("9")) {
                            doble = true;
                        }
                    } else {
                        finalProperties.add((String)this.propertiesNames.get(i));
                    }
                } else {
                    finalProperties.add((String)this.propertiesNames.get(i));
                }
                fragmentoPrecedente = (String)this.propertiesNames.get(i);
            }
            ++i;
        }
        return finalProperties;
    }

    private String cleaner(String literal) {
        String[] corte = this.divisorPunto(literal);
        return corte[corte.length - 1];
    }

    private String arrayCleaner(String literal) {
        String[] literalPiezas = this.divisorPunto(literal);
        return literalPiezas[literalPiezas.length - 1].substring(0, literalPiezas[literalPiezas.length - 1].length() - 1);
    }

    private StringBuffer cadenaComposer(ArrayList eslabones) {
        int t;
        StringBuffer cadena = new StringBuffer();
        ArrayList objEspecial = new ArrayList();
        ArrayList objEspecialConcat = new ArrayList();
        int i = 0;
        while (i < eslabones.size() - 1) {
            if (eslabones.get(i).getClass().getName().equals("java.util.ArrayList")) {
                int j;
                objEspecial = (ArrayList)eslabones.get(i);
                if (((String)objEspecial.get(0)).equals("enumerado")) {
                    cadena.append(this.arrayCleaner((String)objEspecial.get(1)));
                    cadena.append(":");
                    cadena.append("[");
                    j = 1;
                    while (j < objEspecial.size() - 1) {
                        cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecial.get(j))));
                        cadena.append(",");
                        ++j;
                    }
                    cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecial.get(objEspecial.size() - 1))));
                    cadena.append("],");
                } else {
                    cadena.append((String)objEspecial.get(1));
                    cadena.append(":");
                    cadena.append("{");
                    j = 2;
                    while (j < objEspecial.size() - 1) {
                        if (objEspecial.get(j).getClass().getName().equals("java.util.ArrayList")) {
                            int t2;
                            objEspecialConcat = (ArrayList)objEspecial.get(j);
                            if (((String)objEspecialConcat.get(0)).equals("enumerado")) {
                                cadena.append(this.arrayCleaner((String)objEspecialConcat.get(2)));
                                cadena.append(":");
                                cadena.append("[");
                                t2 = 1;
                                while (t2 < objEspecialConcat.size() - 1) {
                                    cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(t2))));
                                    cadena.append(",");
                                    ++t2;
                                }
                                cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(objEspecialConcat.size() - 1))));
                                cadena.append("],");
                            } else {
                                cadena.append((String)objEspecialConcat.get(1));
                                cadena.append(":");
                                cadena.append("{");
                                t2 = 2;
                                while (t2 < objEspecialConcat.size() - 1) {
                                    cadena.append(this.cleaner((String)objEspecialConcat.get(t2)));
                                    cadena.append(":");
                                    cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(t2))));
                                    cadena.append(",");
                                    ++t2;
                                }
                                cadena.append(this.cleaner((String)objEspecialConcat.get(objEspecialConcat.size() - 1)));
                                cadena.append(":");
                                cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(objEspecialConcat.size() - 1))));
                                cadena.append("},");
                            }
                        } else {
                            cadena.append(this.cleaner((String)objEspecial.get(j)));
                            cadena.append(":");
                            cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecial.get(j))));
                            cadena.append(",");
                        }
                        ++j;
                    }
                    if (objEspecial.get(objEspecial.size() - 1).getClass().getName().equals("ArryList")) {
                        objEspecialConcat = (ArrayList)objEspecial.get(objEspecial.size() - 1);
                        if (((String)objEspecialConcat.get(0)).equals("enumerado")) {
                            cadena.append(this.arrayCleaner((String)objEspecialConcat.get(1)));
                            cadena.append(":");
                            cadena.append("[");
                            t = 1;
                            while (t < objEspecialConcat.size() - 1) {
                                cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(t))));
                                cadena.append(",");
                                ++t;
                            }
                            cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(objEspecialConcat.size() - 1))));
                            cadena.append("],");
                        } else {
                            cadena.append((String)objEspecialConcat.get(1));
                            cadena.append(":");
                            cadena.append("{");
                            t = 2;
                            while (t < objEspecialConcat.size() - 1) {
                                cadena.append(this.cleaner((String)objEspecialConcat.get(t)));
                                cadena.append(":");
                                cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(t))));
                                cadena.append(",");
                                ++t;
                            }
                            cadena.append(this.cleaner((String)objEspecialConcat.get(objEspecialConcat.size() - 1)));
                            cadena.append(":");
                            cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(objEspecialConcat.size() - 1))));
                            cadena.append("},");
                        }
                    } else {
                        cadena.append(this.cleaner((String)objEspecial.get(objEspecial.size() - 1)));
                        cadena.append(":");
                        cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecial.get(objEspecial.size() - 1))));
                        cadena.append("},");
                    }
                }
            } else {
                cadena.append("'" + this.cleaner((String)eslabones.get(i)) + "':");
                cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)eslabones.get(i))));
                cadena.append(",");
            }
            ++i;
        }
        if (eslabones.get(eslabones.size() - 1).getClass().getName().equals("java.util.ArrayList")) {
            int j;
            objEspecial = (ArrayList)eslabones.get(eslabones.size() - 1);
            if (((String)objEspecial.get(0)).equals("enumerado")) {
                cadena.append(this.arrayCleaner((String)objEspecial.get(1)));
                cadena.append(":");
                cadena.append("[");
                j = 1;
                while (j < objEspecial.size() - 1) {
                    cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecial.get(j))));
                    cadena.append(",");
                    ++j;
                }
                cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecial.get(objEspecial.size() - 1))));
                cadena.append("]");
            } else {
                cadena.append((String)objEspecial.get(1));
                cadena.append(":");
                cadena.append("{");
                j = 2;
                while (j < objEspecial.size() - 1) {
                    if (objEspecial.get(j).getClass().getName().equals("ArryList")) {
                        objEspecialConcat = (ArrayList)objEspecial.get(j);
                        if (((String)objEspecialConcat.get(0)).equals("enumerado")) {
                            cadena.append(this.arrayCleaner((String)objEspecialConcat.get(1)));
                            cadena.append(":");
                            cadena.append("[");
                            t = 1;
                            while (t < objEspecialConcat.size() - 1) {
                                cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(t))));
                                cadena.append(",");
                                ++t;
                            }
                            cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(objEspecialConcat.size() - 1))));
                            cadena.append("],");
                        } else {
                            cadena.append((String)objEspecialConcat.get(1));
                            cadena.append(":");
                            cadena.append("{");
                            t = 2;
                            while (t < objEspecialConcat.size() - 1) {
                                cadena.append(this.cleaner((String)objEspecialConcat.get(t)));
                                cadena.append(":");
                                cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(t))));
                                cadena.append(",");
                                ++t;
                            }
                            cadena.append(this.cleaner((String)objEspecialConcat.get(objEspecialConcat.size() - 1)));
                            cadena.append(":");
                            cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(objEspecialConcat.size() - 1))));
                            cadena.append("},");
                        }
                    } else {
                        cadena.append("'" + this.cleaner((String)objEspecial.get(j)) + "'");
                        cadena.append(":");
                        cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecial.get(j))));
                        cadena.append(",");
                    }
                    ++j;
                }
                if (objEspecial.get(objEspecial.size() - 1).getClass().getName().equals("ArryList")) {
                    int t3;
                    objEspecialConcat = (ArrayList)objEspecial.get(objEspecial.size() - 1);
                    if (((String)objEspecialConcat.get(0)).equals("enumerado")) {
                        cadena.append(this.arrayCleaner((String)objEspecialConcat.get(1)));
                        cadena.append(":");
                        cadena.append("[");
                        t3 = 1;
                        while (t3 < objEspecialConcat.size() - 1) {
                            cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(t3))));
                            cadena.append(",");
                            ++t3;
                        }
                        cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(objEspecialConcat.size() - 1))));
                        cadena.append("]");
                    } else {
                        cadena.append((String)objEspecialConcat.get(1));
                        cadena.append(":");
                        cadena.append("{");
                        t3 = 2;
                        while (t3 < objEspecialConcat.size() - 1) {
                            cadena.append(this.cleaner((String)objEspecialConcat.get(t3)));
                            cadena.append(":");
                            cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(t3))));
                            cadena.append(",");
                            ++t3;
                        }
                        cadena.append(this.cleaner((String)objEspecialConcat.get(objEspecialConcat.size() - 1)));
                        cadena.append(":");
                        cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecialConcat.get(objEspecialConcat.size() - 1))));
                        cadena.append("}");
                    }
                } else {
                    cadena.append("'" + this.cleaner((String)objEspecial.get(objEspecial.size() - 1)) + "'");
                    cadena.append(":");
                    cadena.append(this.escribirLiteral(this.propertiesTabla.getProperty((String)objEspecial.get(objEspecial.size() - 1))));
                    cadena.append("}");
                }
            }
        } else {
            cadena.append("'" + this.cleaner((String)eslabones.get(eslabones.size() - 1)) + "':");
            cadena.append("'" + this.propertiesTabla.getProperty((String)eslabones.get(eslabones.size() - 1)) + "'");
        }
        return cadena;
    }

    private ArrayList ordenarAlfabeticamenteArray(ArrayList arrayDesordenado) {
        if (arrayDesordenado.size() < 1) {
            return arrayDesordenado;
        }
        if (arrayDesordenado.size() == 1) {
            return arrayDesordenado;
        }
        if (arrayDesordenado.size() == 2) {
            if (this.compararStrings((String)arrayDesordenado.get(0), (String)arrayDesordenado.get(1))) {
                return arrayDesordenado;
            }
            ArrayList salida = new ArrayList();
            salida.add(arrayDesordenado.get(1));
            salida.add(arrayDesordenado.get(0));
            return salida;
        }
        ArrayList subOrdenacion1 = new ArrayList();
        ArrayList subOrdenacion2 = new ArrayList();
        int carga = 0;
        while (carga < arrayDesordenado.size() / 2) {
            subOrdenacion1.add(arrayDesordenado.get(carga));
            ++carga;
        }
        while (carga < arrayDesordenado.size()) {
            subOrdenacion2.add(arrayDesordenado.get(carga));
            ++carga;
        }
        subOrdenacion1 = this.ordenarAlfabeticamenteArray(subOrdenacion1);
        subOrdenacion2 = this.ordenarAlfabeticamenteArray(subOrdenacion2);
        ArrayList arrayOrdenado = new ArrayList();
        int i = 0;
        int j = 0;
        while (i < subOrdenacion1.size() && j < subOrdenacion2.size()) {
            String comp2;
            String comp1 = (String)subOrdenacion1.get(i);
            if (this.compararStrings(comp1, comp2 = (String)subOrdenacion2.get(j))) {
                arrayOrdenado.add(subOrdenacion1.get(i));
                ++i;
                continue;
            }
            arrayOrdenado.add(subOrdenacion2.get(j));
            ++j;
        }
        if (i < subOrdenacion1.size()) {
            while (i < subOrdenacion1.size()) {
                arrayOrdenado.add(subOrdenacion1.get(i));
                ++i;
            }
        }
        if (j < subOrdenacion2.size()) {
            while (j < subOrdenacion2.size()) {
                arrayOrdenado.add(subOrdenacion2.get(j));
                ++j;
            }
        }
        return arrayOrdenado;
    }

    private boolean compararStrings(String palabra1, String palabra2) {
        int longPalabra1 = 0;
        int longPalabra2 = 0;
        while (longPalabra1 < palabra1.length() && longPalabra2 < palabra2.length()) {
            if (this.numero(palabra1.substring(longPalabra1, longPalabra1 + 1)) && this.numero(palabra2.substring(longPalabra2, longPalabra2 + 1))) {
                int num2;
                int num1;
                if (longPalabra1 == 0) {
                    num1 = new Integer(palabra1.substring(longPalabra1, longPalabra1 + 1));
                    num2 = new Integer(palabra2.substring(longPalabra2, longPalabra2 + 1));
                } else {
                    num1 = new Integer(palabra1.substring(longPalabra1, longPalabra1 + 1));
                    num2 = new Integer(palabra2.substring(longPalabra2, longPalabra2 + 1));
                }
                if (num1 == num2) {
                    ++longPalabra1;
                    ++longPalabra2;
                    continue;
                }
                if (num1 < num2) {
                    if (palabra1.length() - 1 > longPalabra1 && this.numero(palabra1.substring(longPalabra1 + 1, longPalabra1 + 2))) {
                        return palabra2.length() - 1 > longPalabra2 && this.numero(palabra2.substring(longPalabra2 + 1, longPalabra2 + 2));
                    }
                    return true;
                }
                if (palabra2.length() - 1 > longPalabra2 && this.numero(palabra2.substring(longPalabra2 + 1, longPalabra2 + 2))) {
                    return palabra1.length() - 1 <= longPalabra1 || !this.numero(palabra1.substring(longPalabra1 + 1, longPalabra1 + 2));
                }
                return false;
            }
            if (palabra1.charAt(longPalabra1) < palabra2.charAt(longPalabra2)) {
                return true;
            }
            if (palabra1.charAt(longPalabra1) == palabra2.charAt(longPalabra2)) {
                ++longPalabra1;
                ++longPalabra2;
                continue;
            }
            return false;
        }
        return palabra1.length() < palabra2.length();
    }

    private boolean numero(String caracter) {
        if (caracter.equals("0")) {
            return true;
        }
        if (caracter.equals("1")) {
            return true;
        }
        if (caracter.equals("2")) {
            return true;
        }
        if (caracter.equals("3")) {
            return true;
        }
        if (caracter.equals("4")) {
            return true;
        }
        if (caracter.equals("5")) {
            return true;
        }
        if (caracter.equals("6")) {
            return true;
        }
        if (caracter.equals("7")) {
            return true;
        }
        if (caracter.equals("8")) {
            return true;
        }
        return caracter.equals("9");
    }

    private String[] divisorPunto(String cadena) {
        int apuntador = 0;
        StringTokenizer tokens = new StringTokenizer(cadena, ".");
        String[] fragmentos = new String[tokens.countTokens()];
        while (tokens.hasMoreTokens()) {
            fragmentos[apuntador] = tokens.nextToken();
            ++apuntador;
        }
        return fragmentos;
    }

    private void cargarLiteralesGridSesion(HttpServletRequest request) {
        Enumeration sesionAtributes = request.getSession().getAttributeNames();
        boolean presente = false;
        while (sesionAtributes.hasMoreElements()) {
            if (!((String)sesionAtributes.nextElement()).equals("gridLiterals")) continue;
            presente = true;
            this.gridLiterals = (HashMap)request.getSession().getAttribute("gridLiterals");
        }
        if (!presente) {
            request.getSession().setAttribute("gridLiterals", new HashMap());
            this.gridLiterals = new HashMap();
        }
    }

    private void cargarLiteralesDialogosSesion(HttpServletRequest request) {
        Enumeration sesionAtributes = request.getSession().getAttributeNames();
        boolean presente = false;
        while (sesionAtributes.hasMoreElements()) {
            if (!((String)sesionAtributes.nextElement()).equals("dialogLiterals")) continue;
            presente = true;
            this.dialogLiterals = (HashMap)request.getSession().getAttribute("dialogLiterals");
        }
        if (!presente) {
            request.getSession().setAttribute("dialogLiterals", new HashMap());
            this.dialogLiterals = new HashMap();
        }
    }

    private void GuardarliteralesSesion(HttpServletRequest request) {
        request.getSession().setAttribute("gridLiterals", (Object)this.gridLiterals);
    }

    private String escribirLiteral(String propertie) {
        if (propertie.split("function").length > 1) {
            return propertie;
        }
        return "'" + propertie + "'";
    }

    private boolean isNumberFloat(String cadena) {
        try {
            Float.parseFloat(cadena);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

